// Modes //

function Practice()
{
	while (true)
	{
		var size = 0;
		while (true)
		{
			BG2.blit(0, 0);
			Screen.blit(0, 0);
			window.drawWindow(SW/2-font.getStringWidth("Waffle size: 00")/2, SH/2-8, font.getStringWidth("Waffle size: 00"), 16);
			font.drawText(SW/2-font.getStringWidth("Waffle size: 00")/2-4, SH/2-24, "Practice Game:");
			font.drawText(SW/2-font.getStringWidth("Waffle size: 00")/2, SH/2-8, "Waffle size: ");
			size = GetString(SW/2-font.getStringWidth("Waffle size: 00")/2+font.getStringWidth("Waffle size: "), SH/2-8, font, 1);
			if (size > 2 && size <= 9 || size == null) break;
		}
		if (size == null) break;
		var GameWaffle = new Waffle(size);
		GameWaffle.title = "Practice Game";
		GameWaffle.canWin = false;
		GameWaffle.showMoveBox = false;
		GameWaffle.showClearButton = true;
		GameWaffle.preRender = function() { BG1.update(2000); BG2.update(2000); Screen.blit(0, 0); }
		GameWaffle.postRender = DoMouse;
		GameWaffle.display(SW/2-GameWaffle.width/2, SH/2-GameWaffle.height/2);
		ClearKeyQueue();
		BG2.blit(0, 0);
		window.drawWindow(SW/2-font.getStringWidth("Waffle size: 00")/2, SH/2-8, font.getStringWidth("Waffle size: 00"), 16);
		font.drawText(SW/2-font.getStringWidth("Waffle size: 00")/2-4, SH/2-24, "Practice Game:");
		font.drawText(SW/2-font.getStringWidth("Waffle size: 00")/2, SH/2-8, "Waffle size: ");
	}
	Delay(250);
	DrawGameModes();
	return 0;
}

function RandomGame()
{
	while (true)
	{
		var size = 0;
		while (true)
		{
			BG2.blit(0, 0);
			Screen.blit(0, 0);
			window.drawWindow(SW/2-font.getStringWidth("Waffle size: 00")/2, SH/2-8, font.getStringWidth("Waffle size: 00"), 16);
			font.drawText(SW/2-font.getStringWidth("Waffle size: 00")/2-4, SH/2-24, "Random Game:");
			font.drawText(SW/2-font.getStringWidth("Waffle size: 00")/2, SH/2-8, "Waffle size: ");
			size = GetString(SW/2-font.getStringWidth("Waffle size: 00")/2+font.getStringWidth("Waffle size: "), SH/2-8, font, 1);
			if (size > 2 && size <= 9 || size == null) break;
		}
		if (size == null) break;
		var GameWaffle = new Waffle(size);
		GameWaffle.title = "Random Game";
		GameWaffle.generateField(G_moves);
		GameWaffle.preRender = function() { BG1.update(2000); BG2.update(2000); Screen.blit(0, 0); }
		GameWaffle.postRender = DoMouse;
		GameWaffle.display(SW/2-GameWaffle.width/2, SH/2-GameWaffle.height/2);
		ClearKeyQueue();
		BG2.blit(0, 0);
		window.drawWindow(SW/2-font.getStringWidth("Waffle size: 00")/2, SH/2-8, font.getStringWidth("Waffle size: 00"), 16);
		font.drawText(SW/2-font.getStringWidth("Waffle size: 00")/2-4, SH/2-24, "Random Game:");
		font.drawText(SW/2-font.getStringWidth("Waffle size: 00")/2, SH/2-8, "Waffle size: ");
	}
	Delay(250);
	DrawGameModes();
	return 0;
}

function Tutorial()
{
	Cursor.setXY(SW, SH);
	var TutSquare = new Waffle(6);
	TutSquare.title = "Tutorial Square";

	var DrawBG = function()
	{
		BG2.blit(0, 0);
		Screen.blit(0, 0);
		TutSquare.drawTitle();
		TutSquare.drawSquares(SW/2-TutSquare.width/2, SH/2-TutSquare.height/2);
	}

	BG2.reset();
	BG2.fadeImage("in");
	do
	{
		BG2.update(2500);
		Screen.blit(0, 0);
		FlipScreen();
	}while(BG2.time + 2500 > GetTime())
	BG2.blit(0, 0);
	Screen.blit(0, 0);
	DrawTextBox(SW/2-80, SH/2-20, 160, 40, "So, you have what it takes to master the game of Squared?");
	FrameWait(400);
	DrawBG();
	DrawTextBox(SW/2-140, SH-50, 280, 32, "This is the basic game square. It is composed of many smaller squares.");
	MoveMouse(TutSquare.xButtons[0].x+8, TutSquare.xButtons[0].y+8, 1000);
	DrawTextBox(SW/2-140, SH-50, 280, 32, "The aim of the game is to completely fill this giant square with white.");
	DrawTextBox(SW/2-140, SH-50, 280, 32, "As you can see, it is already white, so let's mix it up a bit.");
	TutSquare.rotateColumn(0);
	DrawBG();
	MoveMouse(TutSquare.yButtons[0].x+8, TutSquare.yButtons[0].y+8, 300);
	FrameWait(400);
	TutSquare.rotateRow(0);
	DrawBG();
	MoveMouse(TutSquare.yButtons[0].x+8, TutSquare.yButtons[0].y+8, 1);
	DrawTextBox(SW/2-140, SH-50, 280, 32, "Notice how the coloring inverts and the square's positions mirror.");
	FrameWait(400);
	TutSquare.moves = 0;
	TutSquare.drawMoveBox();
	DrawTextBox(SW/2-140, SH-50, 280, 32, "The move box displays the number of moves you have taken.");
	DrawTextBox(SW/2-140, SH-50, 280, 32, "Now, I want you to solve this puzzle. (Remember the buttons I pressed!)");
	DrawBG();
	TutSquare.drawMoveBox();
	MoveMouse(SW/2, SH/2, 500);
	
	TutSquare.preRender = function() { BG2.blit(0, 0); Screen.blit(0, 0); }
	TutSquare.postRender = DoMouse;
	TutSquare.display(SW/2-TutSquare.width/2, SH/2-TutSquare.height/2);

	DrawBG();
	TutSquare.moves = 0;
	TutSquare.drawMoveBox();
	Cursor.draw();
	DrawTextBox(SW/2-140, SH-50, 280, 32, "Congradulations! Now, I want you to try this next pattern:");	
	DrawBG();
	TutSquare.drawMoveBox();
	MoveMouse(TutSquare.xButtons[3].x+8, TutSquare.xButtons[3].y+8, 1000);
	FrameWait(400);
	TutSquare.rotateColumn(3);
	DrawBG();
	TutSquare.drawMoveBox();
	MoveMouse(TutSquare.yButtons[1].x+8, TutSquare.yButtons[1].y+8, 300);
	FrameWait(400);
	TutSquare.rotateRow(1);
	DrawBG();
	TutSquare.drawMoveBox();
	MoveMouse(TutSquare.yButtons[1].x+8, TutSquare.yButtons[1].y+8, 1);
	DrawTextBox(SW/2-140, SH-50, 280, 32, "Notice how the rows and columns to the left or top also get changed.");
	DrawTextBox(SW/2-140, SH-50, 280, 32, "Now, I want you to solve this puzzle. (Remember the buttons I pressed!)");
	DrawBG();
	TutSquare.drawMoveBox();
	MoveMouse(SW/2, SH/2, 500);
	
	TutSquare.display(SW/2-TutSquare.width/2, SH/2-TutSquare.height/2);
	
	DrawBG();
	TutSquare.drawMoveBox();
	Cursor.draw();
	DrawTextBox(SW/2-140, SH-50, 280, 32, "Congradulations! You have learned how to play!");	
	DrawTextBox(SW/2-140, SH-50, 280, 32, "Before you start, I recommend you to play the practice mode.");
	
	BG1.fadeIn(2000);
	BG1.reset();
	BG2.looped = true;
	BG2.loopFade = true;
	GameMenu.draw();
}

function ShowArcadeGames()
{
	// I'm going to essentially wrap around the arcade menu and hack it up //
	var CI = 0;
	var T_CI = 0;
	var active = true;
	with(ArcadeMenu)
	{
		var h = maxHeight*height;
		open(500);
		while(active)
		{
			preRender();
			window.drawWindow(x, y, w, h);
			for (var i = 0; i < maxHeight; ++i)
			{
				if (i < items.length)
				{
					var old_col = font.getColorMask();
					if (CI == i+T_CI && arrow.y == arrow.newY) font.setColorMask(items[i + T_CI].colordown);
					else font.setColorMask(items[i + T_CI].colorup);
					font.drawText(x+12,y+i*height+height/2-font.getHeight()/2,items[i + T_CI].name);
					items[i + T_CI].img.blit(x+font.getStringWidth(items[i + T_CI].name)+16, y+i*height);
					font.setColorMask(old_col);
				}
			}
			arrow.blit();
			FlipScreen();
			
			// Handle Input //
			
			while(AreKeysLeft())
			{
				switch(GetKey())
				{
					case KEY_UP:
						if (CI > 0)
						{
							CI--;
							if (CI < T_CI) T_CI--;
							else arrow.newY -= height;
						}
					break;
					case KEY_DOWN:
						if (CI < items.length-1)
						{
							CI++;
							if (CI >= T_CI + maxHeight) T_CI++;
							else arrow.newY += height;
						}
					break;
					case KEY_CTRL:
					case KEY_SPACE:
					case KEY_ENTER:
						close(500);
						if(this.postRender != undefined) this.postRender();	
						CallGame(items[CI].call);
						return;
					break;
					case KEY_SHIFT:
					case KEY_ESCAPE:
						if(cancelable)
						{
							close(500);
							if(this.postRender != undefined) this.postRender();
							onCancel();
							active = false; // turns menu off
						}
					break;
				}
			}
		}
	}
}